//
//  NSError+Agile.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-05-01.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

@import Foundation;

@interface NSError (Agile)

+ (void)setRootViewController:(id)rootViewController;

+ (NSError *)errorWithCode:(NSInteger)code userInfo:(NSDictionary *)userInfo;
+ (NSError *)errorWithCode:(NSInteger)code description:(NSString *)description;
+ (NSError *)errorWithCode:(NSInteger)code description:(NSString *)description forURL:(NSURL *)url underlyingError:(NSError *)error;
+ (NSError *)errorWithCode:(NSInteger)code description:(NSString *)description forPath:(NSString *)path underlyingError:(NSError *)error;
+ (NSError *)errorWithCode:(NSInteger)code description:(NSString *)description recoverySuggestion:(NSString *)recoverySuggestion forPath:(NSString *)path underlyingError:(NSError *)error;
+ (NSError *)errorWithCode:(NSInteger)code description:(NSString *)description recoverySuggestion:(NSString *)recoverySuggestion forPath:(NSString *)path underlyingError:(NSError *)error helpURL:(NSURL *)helpURL;
+ (instancetype)ag_errorWithDomain:(NSString *)domain code:(NSInteger)code userInfo:(NSDictionary *)userInfo;

- (void)presentError;
- (void)presentErrorForViewController:(id)viewController;
- (BOOL)fileNotFound;

@end

FOUNDATION_EXPORT NSString * const OPErrorDomain;

typedef NS_ENUM(NSInteger, OPErrorCode) {
	OPErrorCodeFileCoordinationError											= 50,
	
	OPErrorCodeFailedToLoadProfile											= 100,
	OPErrorCodeFailedToSaveProfile											= 101,
	OPErrorCodeFailedToDecrypt												= 102,
	OPErrorCodeFailedToUnlockSecondaryProfile								= 103,
	
	OPErrorCodeUbiquityContainerFailedValidation							= 103,
	OPErrorCodeUbiquityContainerContainsStaleData							= 104,
	OPErrorCodeUbiquityContainerMissingProfile								= 105,
	
	OPErrorCodeFailedLoadItemsFromURL										= 110,
	OPErrorCodeFailedToLoadItemsInURLSet										= 111,
	OPErrorCodeFailedToReadObjectFromFileAtURL								= 112,
	OPErrorCodeInvalidObjectContents											= 113,
	OPErrorCodeInvalidObjectJSON												= 114,
	OPErrorCodeFailedToLoadBandFile											= 115,
	OPErrorCodeExistingBandFileMissingItems									= 116,
	OPErrorCodeFailedToLoadConflictItemsFromURL								= 117,
	OPErrorCodeFailedToReadDataFromURL										= 118,
	
	OPErrorCodeFailedToSaveAgileKeychainObject								= 201,
	OPErrorCodeFailedToDecryptProfile										= 202,
	OPErrorCodeFailedToDeleteAgileKeychainObject							= 203,
	
	OPErrorCodeFailedToCreateAgileKeychainDirectory							= 203,
	OPErrorCodeFailedToSaveAgileKeychainEK1									= 204,
	OPErrorCodeFailedToSaveAgileKeychainEK2									= 205,
	OPErrorCodeFailedToSerializeAgileKeychainEKJSON							= 206,
	OPErrorCodeFailedToSaveAgileKeychainEKJSON								= 207,
	
	OPErrorCodeFailedToSyncCannotAccessKeychain								= 250,
	OPErrorCodeFailedToSyncKeychainMovedToTrash								= 251,
	OPErrorCodeFailedToSyncNoKeychain										= 252,
	OPErrorCodeFailedToSyncCannotLoadKeychainProfile						= 253,
	OPErrorCodeFailedToSyncRemoteKeychainUUIDChanged						= 254,
	OPErrorCodeFailedToSyncLocalProfileUUIDChanged							= 255,
	OPErrorCodeFailedToSyncCannotFindSyncSource								= 256,
	
	
	OPErrorCodeFailedToSaveCloudKeychainObject								= 301,
	
	OPErrorImportFailedNoSecurityLevels										= 401,
	
	OPErrorDecryptionFailedWithStatusCodeA									= 501,
	OPErrorDecryptionFailedWithStatusCodeB									= 502,
	
	OPErrorDecryptionFailedTooShort											= 503,
	OPErrorDecryptionFailedWrongLength										= 504,
	OPErrorDecryptionFailedNoHMAC											= 505,
	OPErrorDecryptionFailedHMACMismatch										= 506,
	OPErrorDecryptionCryptorSetupFailed										= 507,
	
	OPErrorEncryptionInternal1												= 531,
	OPErrorEncryptionInternal2												= 531,
	OPErrorEncryptionCryptorSetupFailed										= 532,
	OPErrorEncryptionFailedToCopyRandomData									= 533,
	OPErrorEncryptionFailedFirstBlock										= 534,
	OPErrorEncryptionFailedRemainder											= 535,
	
	OPErrorEncryptFailedToCreateCipherContext								= 536,
	OPErrorEVPEncryptInitFailed												= 537,
	OPErrorEVPGCMSetIVLenFailed												= 538,
	OPErrorEncryptFailedToInitializeKeyAndNonce								= 539,
	OPErrorFailedToSetNonceSize												= 540,
	OPErrorGCMEncryptionFailed												= 541,
	OPErrorGCMEncryptionFinalFailed											= 542,
	OPErrorGCMGetTagFailed													= 543,
	
	OPErrorJOSEInvalidAlg													= 544,
	OPErrorJOSEInvalidContentType											= 545,
	OPErrorJOSEInvalidKeyID													= 546,
	OPErrorJOSEMissingData													= 547,
	OPErrorJOSEMissingIV														= 548,
	OPErrorJOSEInvalidDataLength												= 549,
	
	OPErrorDecryptFailedToCreateCipherContext								= 550,
	OPErrorEVPDecryptInitFailed												= 551,
	OPErrorDecryptFailedToInitializeKeyAndNonce								= 552,
	OPErrorGCMDecryptionFailed												= 553,
	OPErrorGCMDecryptionFinalFailed											= 554,
	OPErrorGCMSetTagFailed													= 555,
	OPErrorGCMAuthFailed														= 556,
	
	OPErrorRSAEncryptFailed													= 557,
	OPErrorRSADecryptFailed													= 558,
	
	OPErrorCodeFailedToListRemoteDataFolder									= 702,
	OPErrorCodeFailedToListDropboxAttachments								= 703,
	OPErrorCodeHasNoRemoteEncryptionKeys										= 704,
	OPErrorCodeFailedToLoadRemoteEKey										= 705,
	OPErrorCodeFailedToUploadEncryptionKey									= 706,
	//OPErrorCodeDropboxKeyMismatch											= 707,
	OPErrorCodeFailedToLoadDropboxMetadataForAttachmentFolder				= 708,
	OPErrorCodeDropboxFailedToDeleteLocalFile								= 709,
	OPErrorCodeDropboxFailedToDeleteLocalFileAfterDeletingRemote			= 710,
	OPErrorCodeDropboxFailedToDeleteRemoteFile								= 711,
	OPErrorCodeDropboxFailedToLoadLocalProfile								= 712,
	OPErrorCodeDropboxFailedToLoadRemoteProfile								= 713,
	OPErrorCodeDropboxHasNoKeychainFolder									= 714,
	OPErrorCodeFailedToListRootFolder										= 715,
	OPErrorCodeFailedToUploadFile											= 716,
	OPErrorCodeFailedToDownloadFile											= 717,
	OPErrorCodeDropboxAuthFailed												= 718,
	OPErrorCodeFailedToCreateTombstoneFile									= 777,
	
	OPErrorCodeFailedToConvertImage											= 801,
	
	OPErrorFailedToCreateProfileAlreadyExists								= 1001,
	
	OPErrorFailedToMarkFavorites												= 1100,
	OPErrorFailedToAddToFolder												= 1101,
	OPErrorFailedToTagItem													= 1102,
	OPErrorFailedToTrashItem													= 1103,
	OPErrorFailedToTrashFolder												= 1104,
	OPErrorFailedToEmptyTrash												= 1105,
	OPErrorFailedToUpdateItemProfileLocked									= 1106,
	OPErrorFailedToUpdateFolderProfileLocked								= 1107,
	OPErrorFailedToMoveItemsToFolderProfileLocked							= 1108,
	OPErrorFailedToTagItemsProfileLocked										= 1109,
	OPErrorFailedToFavoriteItemsProfileLocked								= 1110,
	OPErrorFailedToFavoriteItemProfileLocked								= 1111,
	OPErrorFailedToTrashItemProfileLocked									= 1112,
	OPErrorFailedToDeleteTagProfileLocked									= 1113,
	OPErrorFailedToDeleteFolderProfileLocked								= 1114,
	OPErrorFailedToMoveFolderProfileLocked									= 1115,
	
	OPErrorFailedToCopyAttachmentFile										= 1116,
	OPErrorFailedToSaveAttachmentFile										= 1117,
	OPErrorFailedToLoadAttachmentFile										= 1118,
	
	OPErrorFailedOperationProfileFrozen										= 1119,
	
	OPErrorBackupProfileLocked												= 1200,
	OPErrorBackupAlreadyInProgress											= 1201,
	OPErrorBackupFolderCannotBeCreated										= 1202,
	OPErrorBackupInterupted													= 1203,
	OPErrorBackupArchivingFailed												= 1204,
	OPErrorBackupFolderNotAFolder											= 1205,
	OPErrorBackupFolderNotWritable											= 1205,
	OPErrorBackupOrRestoreAlreadyInProgress									= 1206,
	OPErrorBackupErrorCreatingTemporaryURL									= 1207,
	OPErrorBackupUnzipFailed													= 1208,
	OPErrorBackupMissingFiles												= 1209,
	OPErrorBackupReplaceItemAtURLFailed										= 1210,
	OPErrorBackupDeletingBackupsFailed										= 1211,
	
	OPErrorFailedToChangeMasterPasswordNoDatabase							= 2001,
	OPErrorFailedToChangeMasterPasswordNoProfile							= 2002,
	OPErrorFailedToChangeMasterPasswordProfileLocked						= 2003,
	OPErrorFailedToChangeMasterPasswordDatabaseError						= 2004,
	
	OPErrorFailedToChangeMasterPasswordUserError							= 2005,
	OPErrorFailedToDeleteLocalVaultWrongAppModeError						= 2006,
	OPErrorFailedToDeletePrimaryVaultNoPrimaryVault							= 2007,
	OPErrorFailedPasswordIncorrect											= 2008,

	OPErrorUnsupportedXPCCall												= 3001,
	
	OPErrorBootstrappingKeychainNoFound										= 4001,
	OPErrorBootstrappingFailedToLoadProfile									= 4002,
	
	OPErrorCannotDeletePrimaryProfile										= 5001,
	
	OPErrorWiFiNoServerAddress												= 7001,
	OPErrorWiFiNoServerPort													= 7002,
	OPErrorWiFiNoSecret														= 7003,
	OPErrorWiFiInvalidResponse												= 7004,
	OPErrorWiFiAuthInvalidResponseJSON										= 7005,
	OPErrorWiFiInvalidSessionUUID											= 7006,
	OPErrorWiFiInvalidSessionUUIDMissing										= 7007,
	OPErrorWiFiInvalidPayloadTimestamp										= 7008,
	OPErrorWiFiInvalidPayloadInfo											= 7009,
	OPErrorWiFiInvalidTransportKey											= 7010,
	OPErrorWiFiInvalidResponseJSON											= 7011,
	OPErrorWiFiFailedToUnlockRemoteProfile									= 7013,
	OPErrorWiFiServerError													= 7014,
	OPErrorWiFiFailedToDecrypt												= 7015,
	OPErrorWiFiFailedMakeJSON												= 7016,
	OPErrorWiFiUnknownState													= 7017,
	OPErrorWiFiVersionMismatch												= 7018,
	OPErrorWiFiHandshakeInvalidProfileAttributes							= 7019,
	OPErrorWiFiHandshakeInvalidProfileJSON									= 7020,
	OPErrorWiFiHandshakeNoProfile											= 7021,
	OPErrorWiFiHandshakeSecondaryProfileNotSupported						= 7022,
	OPErrorWiFiSyncSourceMissing												= 7023,
	OPErrorWiFiSyncLocalProfileIsLocked										= 7024,
	OPErrorWiFiSyncRemoteKeychainProfileMissing								= 7025,
	OPErrorWiFiSyncRemoteKeychainProfileLocked								= 7026,
	OPErrorWiFiSyncRemoteProfileMismatch										= 7027,
	
	OPErrorLicensePrimeFailure												= 8001,
	OPErrorLicenseFailedToCreateDirectory									= 8002,
	OPErrorLicenseFailedToWrite												= 8003,
	
	
	OPErrorIntervaultCopyFailedNoDestinationVault							= 9001,
	OPErrorIntervaultCopyFailedPrimaryVaultLocked							= 9002,
	OPErrorIntervaultCopyFailedCannotDecryptVault							= 9003,
	OPErrorIntervaultCopyFailedDocumentsNotSupportedInDestinationVault		= 9004,
	OPErrorIntervaultCopyFailedDocumentsUploadNotComplete					= 9005,
	OPErrorIntervaultCopyFailedDocumentsMovementNotAllowed					= 9006,
	OPErrorIntervaultCopyFailedDocumentsImportNotPossible					= 9007,
	OPErrorIntervaultCopyFailedCategoryNotSupportedInDestinationVault	= 9008,
	
	OPErrorFailedToLoadPendingItemChanges									= 9101,
	OPErrorFailedToSavePendingItemChanges									= 9102,
	OPErrorFailedToArchivePendingItemChanges								= 9103,
	OPErrorFailedToEncryptPendingItemChanges								= 9104,
	OPErrorFailedToRemovePendingItemChanges									= 9105,
	OPErrorFailedToDecryptPendingItemChanges								= 9106,
	
	OPErrorReplicationDisabledProfileMismatch								= 9201,
	OPErrorReplicationDisabledLocalProfileMissing							= 9202,
	OPErrorReplicationDisabledRemoteProfileMissing							= 9203,
	OPErrorReplicationParentRevisionMismatch								= 9204,
	
	OPErrorVulnerabilitiesEnabled											= 10001,
	OPErrorVulnerabilitiesDisabled											= 10002,
	
	OPErrorCloudKitZoneMissing												= 20001,
	OPErrorCloudKitProfileMissing											= 20002,
	OPErrorCloudKitProfileMalformed											= 20003,
	OPErrorCloudKitProfileMismatch											= 20004,
	OPErrorCloudKitSyncSourceMissing											= 20005,
	OPErrorCloudKitNotAvailable												= 20006,
	OPErrorCloudKitCannotDetermineAccountStatus								= 20007,
	OPErrorCloudKitAccountStatusRestricted									= 20008,
	OPErrorCloudKitNoAccount													= 20009,
	OPErrorCloudKitUnknownAccountStatus										= 20010,
	OPErrorCloudKitNotAllowed												= 20011,
	
	OPErrorInvalidLoginItem													= 25000
};

// Addional information transported in error
FOUNDATION_EXPORT NSString * const OPErrorHelpURLKey;
FOUNDATION_EXPORT NSString * const OPErrorUserAccountNameKey;

#pragma mark - B5

FOUNDATION_EXPORT NSString * const B5ServerErrorDomain;

// Error Codes
typedef NS_ENUM(NSUInteger, B5ServerErrorCode) {
	B5ServerErrorCodeSRPExchangeFailure = 1000, // Only used if client can't handle something the server sent down during SRP exchange. 
	B5ServerErrorCodePersonalKeyMissing = 1001,
	B5ServerErrorCodeAuthVerificationError = 1004,
};

FOUNDATION_EXPORT NSString * const B5ClientErrorDomain;

// B5Client Error Codes
FOUNDATION_EXPORT NSInteger const B5ServerErrorCodeInvalidServerURL;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeUserAccountExists;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeProfileEncryptionFailed;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeProfileDecryptionFailed;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodePrimaryProfileLocked;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeNoDiskSpaceForDocument;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeNoTempDiskSpaceForDocument;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeSHA256VerificationFailed;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeOnlyOneUserPerServerAllowed;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeDocumentDownloadFailed;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeDocumentUploadFailed;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodePushItemsFailed;

FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeInvalidServerURL;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeUnreachableServerURL;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeInvalidEmail;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeInvalidAccountKey;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeInvalidPassword;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeInvalidCurrentPassword;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeDatabaseSchemaVersionNewerThanPossible;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeLoginCredentialsNotProvided;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeEmailChanged;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeWrongAccountAuth;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeDeviceReauthorizationRequired;
FOUNDATION_EXPORT NSInteger const B5ClientErrorCodeEmptyTrashFailed;

// Web Session Domain
FOUNDATION_EXPORT NSString * const B5WebSessionErrorDomain;
FOUNDATION_EXPORT NSInteger const B5WebSessionErrorInvalidUserAccount;

// Error User Info Dictionary Keys
FOUNDATION_EXPORT NSString * const B5ServerErrorPersonalKeyMissingUserInfoExpectedPrefix;
FOUNDATION_EXPORT NSString * const B5HTTPURLResponseCodeKey;
FOUNDATION_EXPORT NSString * const B5ServerSessionIdKey;
FOUNDATION_EXPORT NSString * const B5ClientErrorEmailChangedNewEmailKey; // provided on B5ClientErrorCodeEmailChanged errors

#pragma mark - B5 HTTP Requests

FOUNDATION_EXPORT NSString * const B5ServerRequestErrorDomain;

// For these errors will be mapped from or contained in response payload of server error responses in userInfo:  userInfo should contain specifics like { "requestId": x, “errorCode": 100, “errorMessage”: “Some detailed error message” }
// * in the comment means it may not have a payload with an errorCode
typedef NS_ENUM(NSUInteger, B5ServerRequestErrorCode) {
	B5ServerRequestErrorCodeUnknown = 0, // don't know about or handle this error
	B5ServerRequestErrorCodeBadRequest = 100, // 400* the request itself or request parameters are not valid.
	B5ServerRequestErrorCodeOperationNotPermitted = 101, // 403 the requested action is not permitted
	B5ServerRequestErrorCodeAuthenticationRequired = 102, // 401 usually missing session id
	B5ServerRequestErrorCodeInternalServerError = 103, // 500* an unexpected server error was encountered
	B5ServerRequestErrorCodeIncorrectVersionValue = 104, // 409 Incorrect version information has been provided
	B5ServerRequestErrorCodeUnknownImageFormat = 105, // 415 Unknown image format has been provided
	B5ServerRequestErrorCodeRegistrationFailed = 106, // 432 Registration of the account or user has failed
	B5ServerRequestErrorCodeSuspendedLoginFailed = 107, // 435 the user has been suspended
	B5ServerRequestErrorCodeOneManagerMustRemain = 108, // 434 client is attempting to remove the last manager from a vault
	B5ServerRequestErrorCodeDeletedLoginFailed = 109, // 436 the user has been deleted
	B5ServerRequestErrorCodeCannotHandleRequest = 110, // 434 Attempting to do something wrong, i.e. adding inactive person to vault
	B5ServerRequestErrorCodeSignupExpired = 111, // 434 The signup has expired by the time the verification link is clicked
	B5ServerRequestErrorCodeDomainNotAvailable = 112, // 434 the requested domain is not available during signup
	B5ServerRequestErrorCodeRecoveryAwaitingApproval = 113, // 434 account was put into recovery and then the password was changed. Locked out until admin approves recovery
	B5ServerRequestErrorCodeInviteExpired = 114, // 434 Invite has expired
	B5ServerRequestErrorCodeSignupNotApproved = 115, // 434 Signup has not been approved yet
	B5ServerRequestErrorCodeCannotRemoveYourselfFromGroup = 116, // 434 Cannot remove yourself from a group
	B5ServerRequestErrorCodeResourceNotFound = 117, // 434 Resource requested was not found
	B5ServerRequestErrorCodeRequestTooLarge = 118, // 434 Resource supplied is too large
	B5ServerRequestErrorCodeInvalidTeamInvite = 119, // 434 Team invite is invalid
	B5ServerRequestErrorCodeInvalidTeamInviteDomain = 120, // 434 Team invite domain is invalid
	B5ServerRequestErrorCodeTooManyRequests = 121, // 429* the IP address was put into a throttled state and client should back off.
	B5ServerRequestErrorCodeDeprecatedAPI = 125, // 434 Client is out of date and called out to an API that doesn't exist any longer.
};


